function [exalldata,exndata,exraw_cc,ihalldata,ihndata,ihraw_cc] = emverify(cleft_cc,varargin)
%This function is used to verify and find the best classification
%parameters using EM generated synapse objects as ground truth.
%Synatax:   [] = emverify(cleft_cc,'dirname',array)
%Input:     cleft_cc = the EM synapse objects in a CC structure
%           'dirname' = directory where the centroids are
%           'z' = z distance for distance calculations, default = 0.7
%           'x' = x distance, default = 1;
%           'y' = y distance, default = 1;
%           'isgaba' = there are gabaergic clefts in CC
%           'isedge' = edge cases for clefts, so might be iffiy for
%               classification.
%           'thresholds' = the thresholds to test.  Default = 0.02:0.01:0.2
%           'prepost' = the preposts to test. Default = 0:7
%Output:    class_data = a data structure that reports back on the
%               classification paramters.  Includes fields: 
%               

[dirname,z,x,y,type,type2,norm,object,zfilter,nhood,finetime,sav,isgaba,isedge,savram,thresholds,prepost] = parse(varargin);

%now grab those directory names - we are expect a set of directorys with
%virtual stacks right under the root.
dir_struct = dir(dirname);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
idx(1:2) = 0;               %remove the first two directories
dirnames = {dir_struct.name};   %grab the all of the names in the root
dirnames = dirnames(idx);  %don't want the first two
dir_tmp = repmat([dirname filesep],size(dirnames'));    %replicated the directory name for appending

%prepare the output directory
sep_loc = strfind(dirname,filesep);
out_dir = [dirname(1:sep_loc(end)),'EMverify'];
mkdir(dirname(1:sep_loc(end)),'EMverify')  %make the output root directories

%now find the classification directories
%initiate
exori = [];extermi = [];vg1 = [];ihori = [];ihtermi = [];gad = [];
%parse filenames
for j = 1:size(dirnames,2)
    if ~isempty(strfind(dirnames{j},'PSD'))    %found excitatory origin
        exori = j;
    end
    if ~isempty(strfind(dirnames{j},'SYN'))    %found excitatory termini
        extermi = j;
    end
    if ~isempty(strfind(dirnames{j},'VGluT1'))    %found VGluT1
        vg1 = j;
    end
    if ~isempty(strfind(dirnames{j},'GEPH'))    %found Inhibitory origin
        ihori = j;
    end
    if ~isempty(strfind(dirnames{j},'VGAT'))    %found Inhibitory Termini
        ihtermi = j;
    end
    if ~isempty(strfind(dirnames{j},'GAD'))    %found excitatory origin
        gad = j;
    end
end
%now create some input variables for punc_locodist
pathname = [dirname,filesep];
exfilenames = {dirnames{exori},dirnames{extermi},dirnames{vg1}};
ihfilenames = {dirnames{ihori},dirnames{ihtermi},dirnames{gad}};

%now each cell contains the full directory path for ease of use
fulldirnames = cellstr([dir_tmp char(dirnames')]);      
    
%Calculate centroids series excitatory
thresh_num = size(thresholds,2);
prepost_num = size(prepost,2);
[ori_pivots,ori_cc] = find_centroidvstk('dirname',fulldirnames{exori},'type',type,'type2',type2,'object',object,...
    'threshold',thresholds,'norm',norm,'zfilter',zfilter,'finetime',finetime,'dirout',out_dir,'save',sav,'savram',savram);
[termi_pivots,termi_cc] = find_centroidvstk('dirname',fulldirnames{extermi},'type',type,'type2',type2,'object',object,...
    'threshold',thresholds,'norm',norm,'zfilter',zfilter,'finetime',finetime,'dirout',out_dir,'save',sav,'savram',savram);
[third_pivots,third_cc] = find_centroidvstk('dirname',fulldirnames{vg1},'type',type,'type2',type2,'object',object,...
    'threshold',thresholds,'norm',norm,'zfilter',zfilter,'finetime',finetime,'dirout',out_dir,'save',sav,'savram',savram);

% %Parse the cleft CC structure
% glut_cc = cleft_cc;     %glutamate clefts
% glut_cc.PixelIdxList(isgaba) = [];  %synapse objects
% glut_cc.NumObjects = size(glut_cc.PixelIdxList,2);
% gaba_cc = cleft_cc;     %gabaergic clefts
% gaba_cc.PixelIdxList = cleft_cc.PixelIdxList(isgaba);  %synapse objects
% gaba_cc.NumObjects = size(gaba_cc.PixelIdxList,2);
% %now create gaba and glut edge indexs
% glut_edge = setdiff(isedge,isgaba);
% gaba_edge = intersect(isedge,isgaba);

parpool

for i = 1:thresh_num    %ori
    for j = 1:thresh_num     %termi
        for k = 1:thresh_num    %third
            %now put the data together for synapse classification
            vertices = {ori_pivots{i},termi_pivots{j},third_pivots{k}};
            %calculate distances
            [punc_data,all_data] = punc_locodist2('nhood',nhood,'z',z,'x',x,'y',y,'path',pathname,'files',exfilenames,'vertices',vertices,'save',sav);
            %classify synapses
            h = waitbar(0,['Processing: ori(',num2str(thresholds(i)),'), termi(',num2str(thresholds(j)),', third(',num2str(thresholds(k)),')'],...
                'position',[10 100 275 50]);     %initiate progress bar
            for l = 1:prepost_num
                waitbar(l/7,h,['Processing: ori(',num2str(thresholds(i)),'), termi(',num2str(thresholds(j)),', third(',num2str(thresholds(k)),...
                    '), prepost(',num2str(l-1),')']);   %update progress
                %[ndata] = savpivots_loco(data,alldata,ori,termi,ch1,prepost1,fltr3,multi)
                [tmpdata,allidx,idx] = savpivots_loco(punc_data,all_data,1,2,3,prepost(l),2,1);
                %now figure out the false positive and false negative rate
                %first use allidx and idx to go in and parse the PSD CC
                all_cc = ori_cc{i};  %current PSD cc structure
                all_cc.PixelIdxList(allidx) = [];  %synapse objects
                all_cc.NumObjects = size(all_cc.PixelIdxList,2);
                n_cc = ori_cc{i};
                n_cc.PixelIdxList(idx) = [];  %synapse objects nearest
                n_cc.NumObjects = size(n_cc.PixelIdxList,2);
                %now calculate the overlap
                [correct,falsepos,falseneg,oidx,noidx] = objoverlap(cleft_cc,all_cc,isgaba,isedge); %all 
                [n_correct,n_falsepos,n_falseneg,n_oidx,n_noidx] = objoverlap(cleft_cc,n_cc,isgaba,isedge);    %nearest
                %rebuild cc structures
                alldatafalsepos_cc = all_cc;
                alldatafalseneg_cc = cleft_cc;
                alldatacorrect_cc = all_cc;
                alldatacorrectref_cc = cleft_cc;
                alldatafalseneg_edge_cc = cleft_cc;
                alldatacorrectref_edge_cc = cleft_cc;
                if ~isempty(oidx)  %rebuild only if there are changes
                    alldatafalsepos_cc.PixelIdxList = alldatafalsepos_cc.PixelIdxList(noidx.standardset{2});
                    alldatafalseneg_cc.PixelIdxList = alldatafalseneg_cc.PixelIdxList(noidx.standardset{1});
                    alldatacorrect_cc.PixelIdxList = alldatacorrect_cc.PixelIdxList(oidx.standardset{2});
                    alldatacorrectref_cc.PixelIdxList = alldatacorrectref_cc.PixelIdxList(oidx.standardset{1});
                    alldatafalseneg_edge_cc.PixelIdxList = alldatafalseneg_edge_cc.PixelIdxList(oidx.edgeset{1});
                    alldatacorrectref_edge_cc.PixelIdxList = alldatacorrectref_edge_cc.PixelIdxList(oidx.edgeset{1});
                    alldatafalsepos_cc.NumObjects = size(alldatafalsepos_cc.PixelIdxList,2);
                    alldatafalseneg_cc.NumObjects = size(alldatafalseneg_cc.PixelIdxList,2);
                    alldatacorrect_cc.NumObjects = size(alldatacorrect_cc.PixelIdxList,2);
                    alldatacorrectref_cc.NumObjects = size(alldatacorrectref_cc.PixelIdxList,2);
                    alldatafalseneg_edge_cc.NumObjects = size(alldatafalseneg_edge_cc.PixelIdxList,2);
                    alldatacorrectref_edge_cc.NumObjects = size(alldatacorrectref_edge_cc.PixelIdxList,2);
                end
                %n_cc
                ndatafalsepos_cc = n_cc;
                ndatafalseneg_cc = cleft_cc;
                ndatacorrect_cc = n_cc;
                ndatacorrectref_cc = cleft_cc;
                ndatafalseneg_edge_cc = cleft_cc;
                ndatacorrectref_edge_cc = cleft_cc;
                if ~isempty(n_oidx)     %rebuild only if there are changes
                    ndatafalsepos_cc.PixelIdxList = ndatafalsepos_cc.PixelIdxList(n_noidx.standardset{2});
                    ndatafalseneg_cc.PixelIdxList = ndatafalseneg_cc.PixelIdxList(n_noidx.standardset{1});
                    ndatacorrect_cc.PixelIdxList = ndatacorrect_cc.PixelIdxList(n_oidx.standardset{2});
                    ndatacorrectref_cc.PixelIdxList = ndatacorrectref_cc.PixelIdxList(n_oidx.standardset{1});
                    ndatafalseneg_edge_cc.PixelIdxList = ndatafalseneg_edge_cc.PixelIdxList(n_noidx.standardset{1});
                    ndatacorrectref_edge_cc.PixelIdxList = ndatacorrectref_edge_cc.PixelIdxList(n_oidx.standardset{1});
                    ndatafalsepos_cc.NumObjects = size(ndatafalsepos_cc.PixelIdxList,2);
                    ndatafalseneg_cc.NumObjects = size(ndatafalseneg_cc.PixelIdxList,2);
                    ndatacorrect_cc.NumObjects = size(ndatacorrect_cc.PixelIdxList,2);
                    ndatacorrectref_cc.NumObjects = size(ndatacorrectref_cc.PixelIdxList,2);
                    ndatafalseneg_edge_cc.NumObjects = size(ndatafalseneg_edge_cc.PixelIdxList,2);
                    ndatacorrectref_edge_cc.NumObjects = size(ndatacorrectref_edge_cc.PixelIdxList,2);
                end
                %store data
                %three structures - False Positive & False Negative & Correct
                %false positive
                exalldata.falsepositive(i).termi_prepost_third(j,l,k) = falsepos;  %termi in y, prepost in x, thrid in z
                exalldata.falsepositive(i).cc{j,l,k} = alldatafalsepos_cc;
                exndata.falsepositive(i).termi_prepost_third(j,l,k) = n_falsepos;
                exndata.falsepositive(i).cc{j,l,k} = ndatafalsepos_cc;
                %false negative
                exalldata.falsenegative(i).termi_prepost_third(j,l,k) = falseneg(1);  %termi in y, prepost in x, thrid in z
                exalldata.falsenegative(i).cc{j,l,k} = alldatafalseneg_cc;
                exndata.falsenegative(i).termi_prepost_third(j,l,k) = n_falseneg(1);  %termi in y, prepost in x, thrid in z
                exndata.falsenegative(i).cc{j,l,k} = ndatafalseneg_cc;
                exalldata.falsenegative_edge(i).termi_prepost_third(j,l,k) = falseneg(2);  %termi in y, prepost in x, thrid in z
                exalldata.falsenegative_edge(i).cc{j,l,k} = alldatafalseneg_edge_cc;
                exndata.falsenegative_edge(i).termi_prepost_third(j,l,k) = n_falseneg(2);  %termi in y, prepost in x, thrid in z
                exndata.falsenegative_edge(i).cc{j,l,k} = ndatafalseneg_edge_cc;
                %correct
                exalldata.correct(i).termi_prepost_third(j,l,k) = correct;  %termi in y, prepost in x, thrid in z
                exalldata.correct(i).cc{j,l,k} = alldatacorrect_cc; 
                exndata.correct(i).termi_prepost_third(j,l,k) = n_correct;  %termi in y, prepost in x, thrid in z
                exndata.correct(i).cc{j,l,k} = ndatacorrect_cc; 
            end
            close(h)
        end
    end
end
%Consolidate for output
exraw_cc = {ori_cc,termi_cc,third_cc};  %for output
clear ori_cc termi_cc third_cc
%save the data (just in case...)
save([dirname,filesep,'ex_EMverify.mat'],'exraw_cc','exalldata','exndata');

%inhibitory classification test
isglut = 1:1:size(cleft_cc.PixelIdxList,2);
isglut(isgaba) = [];

[ori_pivots,ori_cc] = find_centroidvstk('dirname',fulldirnames{ihori},'type',type,'type2',type2,'object',object,...
    'threshold',thresholds,'norm',norm,'zfilter',zfilter,'finetime',finetime,'dirout',out_dir,'save',sav,'savram',savram);
[termi_pivots,termi_cc] = find_centroidvstk('dirname',fulldirnames{ihtermi},'type',type,'type2',type2,'object',object,...
    'threshold',thresholds,'norm',norm,'zfilter',zfilter,'finetime',finetime,'dirout',out_dir,'save',sav,'savram',savram);
[third_pivots,third_cc] = find_centroidvstk('dirname',fulldirnames{gad},'type',type,'type2',type2,'object',object,...
    'threshold',thresholds,'norm',norm,'zfilter',zfilter,'finetime',finetime,'dirout',out_dir,'save',sav,'savram',savram);

for i = 1:thresh_num    %ori
    for j = 1:thresh_num     %termi
        for k = 1:thresh_num    %third
            %now put the data together for synapse classification
            vertices = {ori_pivots{i},termi_pivots{j},third_pivots{k}};
            %calculate distances
            [punc_data,all_data] = punc_locodist2('nhood',nhood,'z',z,'x',x,'y',y,'path',pathname,'files',ihfilenames,'vertices',vertices,'save',sav);
            %classify synapses
            h = waitbar(0,['Processing: ori(',num2str(thresholds(i)),'), termi(',num2str(thresholds(j)),', third(',num2str(thresholds(k)),')'],...
                'position',[10 100 275 50]);     %initiate progress bar
            for l = 1:prepost_num
                waitbar(l/7,h,['Processing: ori(',num2str(thresholds(i)),'), termi(',num2str(thresholds(j)),', third(',num2str(thresholds(k)),...
                    '), prepost(',num2str(l-1),')']);   %update progress
                %[ndata] = savpivots_loco(data,alldata,ori,termi,ch1,prepost1,fltr3,multi)
                [tmpdata,allidx,idx] = savpivots_loco(punc_data,all_data,1,2,3,prepost(l),2,1);
                %now figure out the false positive and false negative rate
                %first use allidx and idx to go in and parse the PSD CC
                all_cc = ori_cc{i};  %current PSD cc structure
                all_cc.PixelIdxList(allidx) = [];  %synapse objects
                all_cc.NumObjects = size(all_cc.PixelIdxList,2);
                n_cc = ori_cc{i};
                n_cc.PixelIdxList(idx) = [];  %synapse objects nearest
                n_cc.NumObjects = size(n_cc.PixelIdxList,2);
                %now calculate the overlap
                [correct,falsepos,falseneg,oidx,noidx] = objoverlap(cleft_cc,all_cc,isglut,isedge); %all 
                [n_correct,n_falsepos,n_falseneg,n_oidx,n_noidx] = objoverlap(cleft_cc,n_cc,isglut,isedge);    %nearest
                %rebuild cc structures
                alldatafalsepos_cc = all_cc;
                alldatafalseneg_cc = cleft_cc;
                alldatacorrect_cc = all_cc;
                alldatacorrectref_cc = cleft_cc;
                alldatafalseneg_edge_cc = cleft_cc;
                alldatacorrectref_edge_cc = cleft_cc;
                if ~isempty(oidx)  %rebuild only if there are changes
                    alldatafalsepos_cc.PixelIdxList = alldatafalsepos_cc.PixelIdxList(noidx.standardset{2});
                    alldatafalseneg_cc.PixelIdxList = alldatafalseneg_cc.PixelIdxList(noidx.standardset{1});
                    alldatacorrect_cc.PixelIdxList = alldatacorrect_cc.PixelIdxList(oidx.standardset{2});
                    alldatacorrectref_cc.PixelIdxList = alldatacorrectref_cc.PixelIdxList(oidx.standardset{1});
                    alldatafalseneg_edge_cc.PixelIdxList = alldatafalseneg_edge_cc.PixelIdxList(oidx.edgeset{1});
                    alldatacorrectref_edge_cc.PixelIdxList = alldatacorrectref_edge_cc.PixelIdxList(oidx.edgeset{1});
                    alldatafalsepos_cc.NumObjects = size(alldatafalsepos_cc.PixelIdxList,2);
                    alldatafalseneg_cc.NumObjects = size(alldatafalseneg_cc.PixelIdxList,2);
                    alldatacorrect_cc.NumObjects = size(alldatacorrect_cc.PixelIdxList,2);
                    alldatacorrectref_cc.NumObjects = size(alldatacorrectref_cc.PixelIdxList,2);
                    alldatafalseneg_edge_cc.NumObjects = size(alldatafalseneg_edge_cc.PixelIdxList,2);
                    alldatacorrectref_edge_cc.NumObjects = size(alldatacorrectref_edge_cc.PixelIdxList,2);
                end
                %n_cc
                ndatafalsepos_cc = n_cc;
                ndatafalseneg_cc = cleft_cc;
                ndatacorrect_cc = n_cc;
                ndatacorrectref_cc = cleft_cc;
                ndatafalseneg_edge_cc = cleft_cc;
                ndatacorrectref_edge_cc = cleft_cc;
                if ~isempty(n_oidx)     %rebuild only if there are changes
                    ndatafalsepos_cc.PixelIdxList = ndatafalsepos_cc.PixelIdxList(n_noidx.standardset{2});
                    ndatafalseneg_cc.PixelIdxList = ndatafalseneg_cc.PixelIdxList(n_noidx.standardset{1});
                    ndatacorrect_cc.PixelIdxList = ndatacorrect_cc.PixelIdxList(n_oidx.standardset{2});
                    ndatacorrectref_cc.PixelIdxList = ndatacorrectref_cc.PixelIdxList(n_oidx.standardset{1});
                    ndatafalseneg_edge_cc.PixelIdxList = ndatafalseneg_edge_cc.PixelIdxList(n_noidx.standardset{1});
                    ndatacorrectref_edge_cc.PixelIdxList = ndatacorrectref_edge_cc.PixelIdxList(n_oidx.standardset{1});
                    ndatafalsepos_cc.NumObjects = size(ndatafalsepos_cc.PixelIdxList,2);
                    ndatafalseneg_cc.NumObjects = size(ndatafalseneg_cc.PixelIdxList,2);
                    ndatacorrect_cc.NumObjects = size(ndatacorrect_cc.PixelIdxList,2);
                    ndatacorrectref_cc.NumObjects = size(ndatacorrectref_cc.PixelIdxList,2);
                    ndatafalseneg_edge_cc.NumObjects = size(ndatafalseneg_edge_cc.PixelIdxList,2);
                    ndatacorrectref_edge_cc.NumObjects = size(ndatacorrectref_edge_cc.PixelIdxList,2);
                end
                %store data
                %three structures - False Positive & False Negative & Correct
                %false positive
                ihalldata.falsepositive(i).termi_prepost_third(j,l,k) = falsepos;  %termi in y, prepost in x, thrid in z
                ihalldata.falsepositive(i).cc{j,l,k} = alldatafalsepos_cc;
                ihndata.falsepositive(i).termi_prepost_third(j,l,k) = n_falsepos;
                ihndata.falsepositive(i).cc{j,l,k} = ndatafalsepos_cc;
                %false negative
                ihalldata.falsenegative(i).termi_prepost_third(j,l,k) = falseneg(1);  %termi in y, prepost in x, thrid in z
                ihalldata.falsenegative(i).cc{j,l,k} = alldatafalseneg_cc;
                ihndata.falsenegative(i).termi_prepost_third(j,l,k) = n_falseneg(1);  %termi in y, prepost in x, thrid in z
                ihndata.falsenegative(i).cc{j,l,k} = ndatafalseneg_cc;
                ihalldata.falsenegative_edge(i).termi_prepost_third(j,l,k) = falseneg(2);  %termi in y, prepost in x, thrid in z
                ihalldata.falsenegative_edge(i).cc{j,l,k} = alldatafalseneg_edge_cc;
                ihndata.falsenegative_edge(i).termi_prepost_third(j,l,k) = n_falseneg(2);  %termi in y, prepost in x, thrid in z
                ihndata.falsenegative_edge(i).cc{j,l,k} = ndatafalseneg_edge_cc;
                %correct
                ihalldata.correct(i).termi_prepost_third(j,l,k) = correct;  %termi in y, prepost in x, thrid in z
                ihalldata.correct(i).cc{j,l,k} = alldatacorrect_cc; 
                ihndata.correct(i).termi_prepost_third(j,l,k) = n_correct;  %termi in y, prepost in x, thrid in z
                ihndata.correct(i).cc{j,l,k} = ndatacorrect_cc; 
            end
            close(h)
        end
    end
end
%Consolidate for output
ihraw_cc = {ori_cc,termi_cc,third_cc};  %for output
clear ori_cc termi_cc third_cc
%save the data (just in case...)
save([dirname,filesep,'ih_EMverify.mat'],'ihraw_cc','ihalldata','ihndata');

delete(gcp('nocreate'))


%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [dirname,z,x,y,type,type2,norm,object,zfilter,nhood,finetime,sav,isgaba,isedge,savram,thresholds,prepost] = parse(input)

dirname = [];
z = 35;         %for current EM dataset, change if needed
%z = 0.7;
x = 1;
y = 1;
nhood = 250;    %for current EM dataset, change if needed, maybe increase if false negatives too high, decrease if false positives too high
%nhood = 10;
type = 2;
type2 = [0 1 5];      %default is 0; now you can define the accessory data, acquired instead of Luminance
norm = 0.999;
object = 0;
zfilter = 0;
finetime = 1;
sav = 0;
isgaba = [];
isedge = [];
savram = 1;
thresholds = 0.02:0.01:0.2;    %threshold series
prepost = 0:7;

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'dirname'
                    dirname = input{1,i+1};
                case 'z'
                    z = input{1,i+1};
                case 'x'
                    x = input{1,i+1};
                case 'y'
                    y = input{1,i+1};
                case 'type'
                    type = input{1,i+1};
                case 'type2'
                    type2 = input{1,i+1};
                case 'norm'
                    norm = input{1,i+1};
                case 'object'
                    object = input{1,i+1};
                case 'zfilter'
                    zfilter = input{1,i+1};
                case 'finetime'
                    finetime = input{1,i+1};
                case 'save'
                    sav = input{1,i+1};
                case 'isgaba'
                    isgaba = input{1,i+1};
                case 'isedge'
                    isedge = input{1,i+1};
                case 'nhood'
                    nhood = input{1,i+1};
                case 'savram'
                    savram = input{1,i+1};
                case 'thresholds'
                    thresholds = input{1,i+1};
                case 'prepost'
                    prepost = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

%Get the location of the images you want to open
if isempty(dirname)
    dirname = uigetdir2('','Directory where your centroids are');    %get the directory
end

%if isgaba or isedge are logical indexes convert to numeric indexes
if max(isgaba==1)
    isgaba = find(isgaba==1);
end
if max(isedge==1)
    isedge = find(isedge==1);
end

%--------------------------------------------------------------------------
function [ndata,allidx,idx] = savpivots_loco(data,alldata,ori,termi,ch1,prepost1,fltr3,multi)
if nargin==6    %choose default for fltr3
    fltr3 = 2;  %on
    multi = 1;  %on
elseif nargin==7
    multi = 1;  %on
end

%grab some imporant information from the datasets
filenames = data(1).filenames;  %pull out the channel names
tverts = data(ori).termi;   %grab the terminal vertices
tprops = data(ori).termi_prop;   %grab the terminal properties
tdist = data(ori).distance;     %grab the distance to termi

%first create the property index
pcache = tprops(:,:,1);     %example set
pcache(isnan(pcache(:,1)),:) = [];  %remove nan lines
pidx = sum(pcache(:,:));    %grab the first few point for a little test, we pick 5, because changes low that all 5 are not deci
idx_int = round(pidx);   %convert to integer, the size meteric should be the only integer in the lot
idx_tmp = pidx==idx_int;     %where is the int?
idx_tmp = idx_tmp+(median(pcache,1)<100);   %intensity measurements are huge
idx_tmp = idx_tmp+(pidx~=0);     %cannot be zero, size that is
pidx = find(idx_tmp==3);     %find it, meet all criteria, done
if size(pidx,2)>1    %the wild case where the two made it through
    pidx = 2;    %default only really works for me really
end
clear pcache

%lets generate the classes and the index
%           idx = the index of the synaptic subset
[allidx,idx,adata,neardata] = punc_colo_all(alldata,ori,ch1,'termi',termi,'mod',1,'mod_fltr',1,'pp_fltr',1,'prepost',prepost1,'fltr3',fltr3,'visual',0,'multi',multi); %class 1

h = waitbar(0,'Processing Properties of: ');    %initialize progress bar.
count = [];
acount = [];
aucount = [];
for i = 1:size(filenames,2)     %go through the channels
    %initiate
    sdata = [];
    vert_tmp = [];
    prop_tmp = [];
    %process filename
    strmask = isspace(filenames{i});
    spcloc = find(strmask==1);
    filename = strtrim(filenames{i}(min(spcloc):max(spcloc)));
    celllabels{i} = filename;  %create a cell array of file names to label the count files
    waitbar(i/size(filenames,2),h,['Processing Properties of: ' filename]);   %update progress
    if i==ori   %process for data at the origin
        %get self data (self=ori)
        %the nearest index - Note: the ori and the termi is
        %identical for all channels in the neardata and adata structures,
        %so I am just taking the first set.
        vert_tmp = cell2mat(neardata(1).vert);
        prop_tmp = cell2mat(neardata(1).oprop);
        c1 = vert_tmp;           %store this for later use
        %the ori verts are duplicated in the data structure, and I think is
        %unnecessary here, so we are choosing the parsimonenous set.
        avert_tmp = cell2mat(adata(1).vert);
        aprop_tmp = cell2mat(adata(1).oprop);
    elseif i==termi
        vert_tmp = cell2mat(neardata(1).termi);
        prop_tmp = cell2mat(neardata(1).tprop);
        c2 = vert_tmp;           %store this for later use
        %remove duplicates where applicable.
        avert_tmp = cell2mat(adata(1).termi);
        aprop_tmp = cell2mat(adata(1).tprop);
    elseif max(i==ch1)  %the third channel
        curr_chan = find(ch1==i);   %get the location in the data structure where the channel is.
        vert_tmp = cell2mat(neardata(curr_chan).third);
        prop_tmp = cell2mat(neardata(curr_chan).thirdprop);
        avert_tmp = cell2mat(adata(curr_chan).third);
        aprop_tmp = cell2mat(adata(curr_chan).thirdprop);
    else        %not one of the specified channels
        vert_tmp = tverts(:,:,i);    %all ori vertices
        vert_tmp(idx,:) = [];             %all relavent vertices
        %vert_tmp(isnan(vert_tmp(:,1)),:) = [];  %remove nan lines
        prop_tmp = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties + distance
        prop_tmp(idx,:) = [];         %all of the relavent vertices
        %prop_tmp(isnan(prop_tmp(:,1)),:) = [];   %remove nan lines
        avert_tmp = tverts(:,:,i);    %all ori vertices
        avert_tmp(allidx,:) = [];             %all relavent vertices
        %avert_tmp(isnan(vert_tmp(:,1)),:) = [];  %remove nan lines
        aprop_tmp = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        aprop_tmp(allidx,:) = [];         %all of the relavent vertices
        %aprop_tmp(isnan(prop_tmp(:,1)),:) = [];   %remove nan lines
    end
    %generate the dataset for the count numbers
    count = [count size(vert_tmp,1)];   %get the number of vertices for each channel
    acount = [acount size(avert_tmp,1)];    %do the same for the all data
    aucount = [aucount size(unique(avert_tmp,'rows'),1)];   %get the unique count from all data
    %calculate the summary data
    %no outliers - Note: This calcuation is based on the second row, which
    %in my dataset is the size parameter, but might need to be changed if
    %you want another paramater to be the key one.
    prop_cache = prop_tmp;   %we now want the prop to match the vert output, so work on a temporary var instead
    prop_cache(isnan(prop_cache(:,1)),:) = [];  %remove nan lines
%     out = median(prop_cache(:,pidx))+std(prop_cache(:,pidx))*3;     %3 times the standard deviation should do it.
%     [x,y] = find(prop_cache(:,pidx)>out);        %find the outliers.
%     prop_cache(x,:) = [];             %remove the outliers
    sdata(1,:) = mean(prop_cache,1);
    sdata(2,:) = std(prop_cache,1);
    sdata(3,:) = size(prop_cache,1);
    sdata(4,:) = median(prop_cache,1);
    %do this for the all property
    %for the property calculation we are going to make this a little more
    %parsimonious using fltr3
%     if fltr3>=1
%         [cache,fltr3_idx] = unique(avert_tmp,'rows');   %figure out the duplicated vertices
%         aprop_tmp = aprop_tmp(fltr3_idx,:);     %unique properties
%     end
    aprop_cache = aprop_tmp;
    aprop_cache(isnan(aprop_cache(:,1)),:) = [];  %remove nan lines
%     out = median(aprop_cache(:,pidx))+std(aprop_cache(:,pidx))*3;     %3 times the standard deviation should do it.
%     [x,y] = find(aprop_cache(:,pidx)>out);        %find the outliers.
%     aprop_cache(x,:) = [];             %remove the outliers
    asdata(1,:) = mean(aprop_cache,1);
    asdata(2,:) = std(aprop_cache,1);
    asdata(3,:) = size(aprop_cache,1);
    asdata(4,:) = median(aprop_cache,1);
    %store to ndata
    ndata(i).pivots = vert_tmp;
    ndata(i).props = prop_tmp;
    ndata(i).sum = sdata;
    ndata(i).apivots = avert_tmp;
    ndata(i).aprops = aprop_tmp;
    ndata(i).asum = asdata;
end
close(h)

%--------------------------------------------------------------------------
function [onum,nonum,nonum_ref,oidx,noidx] = objoverlap(ref_cc,obj_cc,rmidx,edgeidx)
%ref_cc = reference CC
%obj_cc = experimental CC
%onum = number of overlapped objects  (correct)
%nonum = number of non-overlapped objects   (false positive)
%nonum_ref =  number of non-overlapped objects for ref_cc (false negative)
%oidx{1} = index of overlapped objects in ref_cc 
%oidx{2} = index of overlapped objects in obj_cc
%noidx{1} = index of non-overlapped objects in ref_cc
%noidx{2} = index of non-overlapped objects in obj_cc
%rmidx = remove these objects, e.g., gabaergic clefts for glutamatergic
%   synapses
%edgeidx = edge cases to consider

ref_objs = ref_cc.PixelIdxList; %grab the objects
objs = obj_cc.PixelIdxList; %ditto

overlap_ptr = 1;
for i = 1:size(objs,2)      %step through each object
    for j = 1:size(ref_objs,2)  %screen through each reference object
        overlap = intersect(objs{i},ref_objs{j});  %is there overlap
        if ~isempty(overlap)  %found overlap
            oidx1(overlap_ptr) = j;
            oidx2(overlap_ptr) = i;
            overlap_ptr = overlap_ptr+1;
            break
        end
    end
end

if overlap_ptr~=1   %there is overlap
    %now figure out no overlap
    noidx1 = 1:1:size(ref_objs,2);      %initialize with all objects first
    noidx2 = 1:1:size(objs,2);
    noidx1 = setdiff(noidx1,oidx1);     %those that did not have overlap
    noidx1 = setdiff(noidx1,rmidx);     %remove these clefts from false negative consideration
    noidx2 = setdiff(noidx2,oidx2);
    %now make the output
    onum = size(oidx2,2);           %correct
    nonum = size(noidx2,2);         %false positives
    nonum_ref(1) = size(noidx1,2);     %false negatives
    oidx.standardset = {setdiff(oidx1,rmidx),oidx2};
    noidx.standardset = {setdiff(noidx1,rmidx),noidx2};
    %now consider edge cases
    onum = size(oidx2,2);    %should be the same as (1), but if say PSD is placed on a GABA cleft, that would not be correct
    nonum = size(noidx2,2);  %PSD on GABA would a false positive as well
    nonum_ref(2) = size(noidx1,2)-size(intersect(noidx1,edgeidx),2);     %false negatives
    oidx.edgeset = {setdiff(setdiff(oidx1,rmidx),edgeidx),oidx2};
    noidx.edgeset = {setdiff(setdiff(noidx1,rmidx),edgeidx),noidx2};
else    %there is no overlap
    onum = 0;   %no overlap
    nonum = size(objs,2);   %everything are false positives
    nonum_ref = [size(ref_objs,2) size(ref_objs,2)];   %everything is fals negatives
    oidx = [];  %none
    noidx = []; %none
end